<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Utilizador') }}
        </h2>
    </x-slot>
    
    <div class="py-12 pt-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700">
                            <th class="font-bold text-left px-4 py-4">Dados do Utilizador</th>
                        </thead>
                        <tbody>
                           <?php $counter=0;  ?>
                                <tr>
                                    <td>
                                        <span class="font-normal w-[65%]"><b>Nome: </b>{{$users[0]->name}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Email: </b>{{$users[0]->userEmail}}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Papel :</b> {{$users[0]->role }}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Estado:</b> {{$users[0]->estado }}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Entidade:</b> {{$users[0]->nome }}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Cadastrado aos </b>{{ $users[0]->created_at }}</span>
                                        <br>
                                        <span class="font-normal w-[65%]"><b>Actualizado aos </b>{{ $users[0]->updated_at }}</span>
                                    </td>
                                    <td>
                                        @if ($users[0]->photo==null or $users[0]->photo=='')
                                            <span class="font-normal w-[65%]">
                                                <a href="{{ asset('assets/img/user/sem-foto.jpg') }}" target="_blank">
                                                    <img src="{{ asset('assets/img/user/sem-foto.jpg') }}" alt="Image" style="width: 100px; height: 100px;">
                                                </a>
                                            </span>
                                        @else
                                            <span class="font-normal w-[65%]">
                                                <a href="{{asset('assets/img/user/') }}/{{ $users[0]->photo }}" target="_blank" rel="noopener noreferrer">
                                                    <img src="{{asset('assets/img/user/') }}/{{ $users[0]->photo }}" style="width: 100px; height: 100px;">
                                                </a>
                                            </span>
                                        @endif
                                        

                                    </td>
                                    
                                </tr> 
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
